define([
    'underscore',
    'backbone',
    'App',
    'modules/page/popup/popup-view',
    'text!modules/learn-about-community-care/learn-about-community-care.html',
    'modules/page/popup/external-nav-popup-view',
], function(_, Backbone, app, PopupView, template, ExternalNavigationWarningPopup) {
    'use strict';

    return PopupView.extend({
        template: _.template(template),
        events: _.extend({}, PopupView.prototype.events, {
            'popupafterclose': 'queuePopupOrDestroy',
            'click .external-link': 'openExternalLink',
        }),
        queuePopupOrDestroy: function() {
            if (!this._preventDestroy) {
                this.destroy();
            } // else retain popup-view to show after cancelling opening external link
        },
        templateContext: function() {
            return {
                veteranChoiceProgram: app.externalLinks.get('veteran-choice-program').toJSON(),
                approvedProvidersLink: app.externalLinks.get('approved-providers').toJSON(),
            };
        },
        openExternalLink: function(e) {
            var $link;
            var navigationWarning;

            e.preventDefault();

            $link = $(e.currentTarget);
            navigationWarning = new (ExternalNavigationWarningPopup.extend({focusOnElAfterClose: _.noop}))({
                elAfterClose: $link,
                model: new Backbone.Model({href: $link.attr('href')}),
            });

            this._preventDestroy = true;
            this.listenToOnce(navigationWarning, 'before:destroy', function() {
                this._preventDestroy = false;
                this.openPopup();
            });
            this.closePopup();
            navigationWarning.openPopup();
        },
    });
});
